/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client.maven;

import com.hello2morrow.sonargraph.build.api.FailSet;
import com.hello2morrow.sonargraph.build.api.IssueFilter;
import com.hello2morrow.sonargraph.build.api.ModuleDTO;
import com.hello2morrow.sonargraph.build.api.RootPathDTO;
import com.hello2morrow.sonargraph.build.api.SystemDTO;
import com.hello2morrow.sonargraph.build.client.IBuildClientImplementation;
import com.hello2morrow.sonargraph.build.client.SonargraphBuildExecutor;
import com.hello2morrow.sonargraph.build.client.maven.Exclude;
import com.hello2morrow.sonargraph.build.client.maven.Include;
import com.hello2morrow.sonargraph.build.client.maven.MavenFailSet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

@Mojo(name="create-report", aggregator=true)
public class SonargraphReportMojo
extends AbstractMojo
implements IBuildClientImplementation {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter
    private File installationDirectory;
    @Parameter(required=true)
    private File systemDirectory;
    @Parameter
    private String activationCode;
    @Parameter
    private String licenseFile;
    @Parameter(defaultValue="Java")
    private String languages;
    @Parameter
    private File reportDirectory;
    @Parameter
    private String reportName;
    @Parameter(defaultValue="html")
    private String reportFormat;
    @Parameter(defaultValue="standard")
    private String reportType;
    @Parameter(defaultValue="false")
    private boolean prepareForSonarQube;
    @Parameter(defaultValue="false")
    private boolean autoUpdate;
    @Parameter
    private File snapshotDirectory;
    @Parameter
    private String snapshotFileName;
    @Parameter
    private String useHttpProxyHost;
    @Parameter
    private File logFile;
    @Parameter
    private String logLevel;
    @Parameter
    private String virtualModel;
    @Parameter
    private String workspaceProfile;
    @Parameter
    private String sonargraphBuildVersion;
    @Parameter
    private MavenFailSet failSet;
    private String m_proxyHost;
    private String m_proxyPort;
    private String m_proxyUsername;
    private String m_proxyPassword;

    private void determineHttpProxyParameters() throws MojoExecutionException {
        if (this.useHttpProxyHost != null) {
            List proxies = this.settings.getProxies();
            for (Object next : proxies) {
                if (!(next instanceof Proxy)) {
                    this.getLog().error((CharSequence)("Not a proxy object: " + next.getClass().getName()));
                    continue;
                }
                Proxy proxy = (Proxy)next;
                if (!proxy.getProtocol().toLowerCase().equals("http") || !proxy.getHost().equals(this.useHttpProxyHost) && !proxy.getId().equals(this.useHttpProxyHost)) continue;
                this.m_proxyHost = proxy.getHost();
                this.m_proxyPort = Integer.toString(proxy.getPort());
                this.m_proxyUsername = proxy.getUsername();
                this.m_proxyPassword = proxy.getPassword();
                break;
            }
            if (this.m_proxyHost == null) {
                String msg = String.format("Cannot locate proxy '%s' in Maven settings", this.useHttpProxyHost);
                this.getLog().info((CharSequence)msg);
                throw new MojoExecutionException(msg);
            }
        }
    }

    public void execute() throws MojoExecutionException {
        this.determineHttpProxyParameters();
        SonargraphBuildExecutor executor = new SonargraphBuildExecutor((IBuildClientImplementation)this);
        try {
            executor.validateParameters();
            executor.executeBuild();
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    public void configureClassPath(File osgiJarFile) throws MojoExecutionException {
        assert (osgiJarFile != null && osgiJarFile.canRead());
        ClassRealm classLoader = (ClassRealm)Thread.currentThread().getContextClassLoader();
        try {
            URL osgiJarURL = osgiJarFile.toURI().toURL();
            classLoader.addURL(osgiJarURL);
        }
        catch (MalformedURLException e) {
            this.error(String.format("Unexpected MalformedURLException: %s", e.getMessage()));
        }
    }

    public boolean supportsDynamicDownload() {
        return true;
    }

    public void info(String msg) {
        this.getLog().info((CharSequence)msg);
    }

    public void error(String msg) throws MojoExecutionException {
        this.getLog().error((CharSequence)msg);
        throw new MojoExecutionException(msg);
    }

    public String getActivationCode() {
        return this.activationCode;
    }

    public FailSet getFailSet() {
        if (this.failSet == null) {
            return null;
        }
        FailSet internalFailSet = new FailSet();
        internalFailSet.setFailOnEmptyWorkspace(this.failSet.isFailOnEmptyWorkspace());
        for (Include include : this.failSet.getIncludes()) {
            internalFailSet.addIncludeIssueFilter(new IssueFilter.Builder().issueType(include.getIssueType()).severity(include.getSeverity()).resolution(include.getResolution()).create());
        }
        for (Exclude exclude : this.failSet.getExcludes()) {
            internalFailSet.addExcludeIssueFilter(new IssueFilter.Builder().issueType(exclude.getIssueType()).severity(exclude.getSeverity()).resolution(exclude.getResolution()).create());
        }
        return internalFailSet;
    }

    public String getHttpProxyHost() {
        return this.m_proxyHost;
    }

    public String getHttpProxyPassword() {
        return this.m_proxyPassword;
    }

    public String getHttpProxyPort() {
        return this.m_proxyPort;
    }

    public String getHttpProxyUser() {
        return this.m_proxyUsername;
    }

    public File getInstallationDirectory() {
        return this.installationDirectory;
    }

    public String getLanguages() {
        return this.languages;
    }

    public String getLicenseFile() {
        return this.licenseFile;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public File getReportDirectory() {
        return this.reportDirectory;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getReportType() {
        return this.reportType;
    }

    public File getSnapshotDirectory() {
        return this.snapshotDirectory;
    }

    public String getSnapshotFileName() {
        return this.snapshotFileName;
    }

    public File getSystemDirectory() {
        return this.systemDirectory;
    }

    public String getVirtualModel() {
        return this.virtualModel;
    }

    public String getWorkspaceProfile() {
        return this.workspaceProfile;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public boolean isPrepareForSonarQube() {
        return this.prepareForSonarQube;
    }

    public String getSonargraphBuildVersion() {
        return this.sonargraphBuildVersion;
    }

    public File getDefaultOutputDirectory() {
        return new File(this.project.getBuild().getDirectory(), "sonargraph");
    }

    public List<File> getTargetDirectoriesOfProjects() {
        ArrayList<File> result = new ArrayList<File>();
        result.add(new File(this.project.getBuild().getDirectory()));
        for (MavenProject nextProject : this.project.getCollectedProjects()) {
            if (nextProject.getPackaging().equals("pom")) {
                this.info("Distribute Sonargraph SonarQube report. Skipping project with 'pom' packaging: " + nextProject.getGroupId() + "." + nextProject.getArtifactId());
                continue;
            }
            result.add(new File(nextProject.getBuild().getDirectory()));
        }
        return result;
    }

    private RootPathDTO createRootPathIfExists(String path, RootPathDTO.Category category) {
        if (path != null && new File(path).isDirectory()) {
            return new RootPathDTO(path, category);
        }
        return null;
    }

    private ModuleDTO processMavenProject(MavenProject p) {
        String testOutDir;
        RootPathDTO testOut;
        RootPathDTO root;
        ArrayList<RootPathDTO> validRootPaths = new ArrayList<RootPathDTO>();
        boolean hasSource = false;
        boolean hasClass = false;
        for (String src : p.getCompileSourceRoots()) {
            root = this.createRootPathIfExists(src, RootPathDTO.Category.SOURCE);
            if (root == null) continue;
            validRootPaths.add(root);
            hasSource = true;
        }
        for (String src : p.getTestCompileSourceRoots()) {
            root = this.createRootPathIfExists(src, RootPathDTO.Category.TEST);
            if (root == null) continue;
            validRootPaths.add(root);
        }
        String outDir = p.getBuild().getOutputDirectory();
        RootPathDTO out = this.createRootPathIfExists(outDir, RootPathDTO.Category.OUT);
        if (out != null) {
            validRootPaths.add(out);
            hasClass = true;
        }
        if ((testOut = this.createRootPathIfExists(testOutDir = p.getBuild().getTestOutputDirectory(), RootPathDTO.Category.TEST_OUT)) != null) {
            validRootPaths.add(testOut);
        }
        if (hasSource && hasClass) {
            ModuleDTO module = new ModuleDTO(p.getGroupId(), p.getArtifactId(), "Java");
            for (RootPathDTO root2 : validRootPaths) {
                module.addRootPath(root2);
            }
            return module;
        }
        return null;
    }

    public SystemDTO getSystemModel() {
        SystemDTO system = new SystemDTO(this.project.getGroupId(), this.project.getArtifactId(), this.project.getBasedir().getAbsolutePath());
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        HashMap<String, ModuleDTO> artifactMap = new HashMap<String, ModuleDTO>();
        HashMap<MavenProject, ModuleDTO> moduleMap = new HashMap<MavenProject, ModuleDTO>();
        projects.add(this.project);
        for (MavenProject p : this.project.getCollectedProjects()) {
            if (p.getPackaging().equals("pom")) continue;
            projects.add(p);
        }
        for (MavenProject p : projects) {
            ModuleDTO module = this.processMavenProject(p);
            if (module == null) continue;
            artifactMap.put(p.getGroupId() + ':' + p.getArtifactId(), module);
            moduleMap.put(p, module);
            system.addModule(module);
        }
        for (MavenProject p : projects) {
            ModuleDTO from = (ModuleDTO)moduleMap.get(p);
            if (from == null) continue;
            for (Dependency dep : p.getDependencies()) {
                String key;
                ModuleDTO target;
                if (!dep.getScope().equals("compile") || (target = (ModuleDTO)artifactMap.get(key = dep.getGroupId() + ':' + dep.getArtifactId())) == null) continue;
                from.addModuleDependency(target);
            }
        }
        return system.hasModules() ? system : null;
    }
}

