/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client.maven;

import com.hello2morrow.sonargraph.build.api.DynamicSystemRequest;
import com.hello2morrow.sonargraph.build.api.ReportRequest;
import com.hello2morrow.sonargraph.build.api.StartupRequest;
import com.hello2morrow.sonargraph.build.api.SystemInfo;
import com.hello2morrow.sonargraph.build.api.SystemOpenRequest;
import com.hello2morrow.sonargraph.build.client.CreateReportInteraction;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildInteraction;
import com.hello2morrow.sonargraph.build.client.maven.AbstractSonargraphReportMojo;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="dynamic-report", aggregator=true)
public final class SonargraphDynamicReportMojo
extends AbstractSonargraphReportMojo {
    @Parameter(property="sonargraph.systemBaseDirectory", required=false)
    private File systemBaseDirectory;
    @Parameter(property="sonargraph.systemId", required=false)
    private String systemId;
    @Parameter(defaultValue="false", property="sonargraph.useGroupIdInModuleName", required=false)
    private boolean useGroupIdInModuleName;
    @Parameter(defaultValue="", property="sonargraph.tsConfigPath", required=false)
    private String tsConfigPath;
    @Parameter(defaultValue="", property="sonargraph.pythonRoot", required=false)
    private String pythonRoot;
    @Parameter(defaultValue="", property="sonargraph.pythonVirtualModel", required=false)
    private String pythonVirtualEnvironment;

    @Override
    public List<ISonargraphBuildInteraction> createInteractions(MavenProject project, StartupRequest startupRequest) throws MojoExecutionException {
        DynamicSystemRequest systemRequest = this.createDynamicSystemRequest(project);
        SystemOpenRequest openRequest = this.createOpenRequest(project, null, false);
        ReportRequest reportRequest = this.createReportRequest(project);
        reportRequest.setUseSonargraphId(false);
        CreateReportInteraction createReport = new CreateReportInteraction(this, systemRequest, openRequest, reportRequest, this.convertFailSet());
        return Arrays.asList(createReport);
    }

    @Override
    protected File getTsConfigFile() {
        if (this.tsConfigPath == null || this.tsConfigPath.isBlank()) {
            return null;
        }
        return new File(this.getProjectDirectory(), this.tsConfigPath.trim());
    }

    @Override
    protected File getPythonRoot() {
        if (this.pythonRoot == null || this.pythonRoot.isBlank()) {
            return null;
        }
        return new File(this.getProjectDirectory(), this.pythonRoot.trim());
    }

    @Override
    protected File getPythonVirtualEnvironment() {
        if (this.pythonVirtualEnvironment == null || this.pythonVirtualEnvironment.isBlank()) {
            return null;
        }
        return new File(this.getProjectDirectory(), this.pythonVirtualEnvironment.trim());
    }

    private DynamicSystemRequest createDynamicSystemRequest(MavenProject project) {
        File baseDirectory = this.systemBaseDirectory != null ? this.systemBaseDirectory : this.getDefaultOutputDirectory();
        SystemInfo systemInfo = this.getSystemModel(project, this.systemId, baseDirectory, this.useGroupIdInModuleName);
        DynamicSystemRequest request = new DynamicSystemRequest(systemInfo);
        File qualityModelFile = this.getQualityModelFile();
        if (qualityModelFile != null) {
            if (qualityModelFile.getName().startsWith("Sonargraph:")) {
                request.setQualityModelFile(qualityModelFile.getName());
            } else {
                request.setQualityModelFile(qualityModelFile.getAbsolutePath());
            }
        }
        return request;
    }
}

