/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client.maven;

import com.hello2morrow.sonargraph.build.api.FailSet;
import com.hello2morrow.sonargraph.build.api.IssueFilter;
import com.hello2morrow.sonargraph.build.api.ModuleInfo;
import com.hello2morrow.sonargraph.build.api.ReportRequest;
import com.hello2morrow.sonargraph.build.api.RootPathInfo;
import com.hello2morrow.sonargraph.build.api.StartupRequest;
import com.hello2morrow.sonargraph.build.api.SystemInfo;
import com.hello2morrow.sonargraph.build.api.SystemOpenRequest;
import com.hello2morrow.sonargraph.build.client.maven.AbstractSonargraphMojo;
import com.hello2morrow.sonargraph.build.client.maven.Exclude;
import com.hello2morrow.sonargraph.build.client.maven.Include;
import com.hello2morrow.sonargraph.build.client.maven.MavenFailSet;
import com.hello2morrow.sonargraph.build.client.maven.MavenPackaging;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

abstract class AbstractSonargraphReportMojo
extends AbstractSonargraphMojo {
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="Java", property="sonargraph.languages")
    private String languages;
    @Parameter(defaultValue="false", property="sonargraph.includeTestCode")
    private boolean includeTestCode;
    @Parameter(defaultValue="false", property="sonargraph.includeEmptyModules")
    private boolean includeEmptyModules;
    @Parameter(property="sonargraph.virtualModel")
    private String virtualModel;
    @Parameter(property="sonargraph.qualityModelFile")
    private File qualityModelFile;
    @Parameter(property="sonargraph.snapshotDirectory")
    private File snapshotDirectory;
    @Parameter(property="sonargraph.snapshotFileName")
    private String snapshotFileName;
    @Parameter(property="sonargraph.reportDirectory")
    private File reportDirectory;
    @Parameter(property="sonargraph.reportFileName")
    private String reportFileName;
    @Parameter(defaultValue="standard", property="sonargraph.reportType")
    private String reportType;
    @Parameter(defaultValue="html", property="sonargraph.reportFormat")
    private String reportFormat;
    @Parameter(property="sonargraph.baselineReportPath")
    private String baselineReportPath;
    @Parameter(defaultValue="false", property="sonargraph.splitByModule")
    private boolean splitByModule;
    @Parameter(defaultValue="0", property="sonargraph.elementCountToSplitHtmlReport")
    private int elementCountToSplitHtmlReport;
    @Parameter(defaultValue="0", property="sonargraph.maxElementCountForHtmlDetailsPage")
    private int maxElementCountForHtmlDetailsPage;
    @Parameter(defaultValue="false", property="sonargraph.prepareForSonarQube")
    private boolean prepareForSonarQube;
    @Parameter(property="sonargraph.timestamp")
    private String timestamp;
    @Parameter(property="sonargraph.contextInfo")
    private String contextInfo;
    @Parameter(property="sonargraph.workspaceProfile")
    private String workspaceProfile;
    @Parameter(defaultValue="default", property="sonargraph.branch")
    private String branch;
    @Parameter(property="sonargraph.version")
    private String version;
    @Parameter(property="sonargraph.commitId")
    private String commitId;
    @Parameter
    private MavenFailSet failSet;

    AbstractSonargraphReportMojo() {
    }

    @Override
    protected final void modifyStartupRequest(StartupRequest startupRequest) {
        if (this.getTsConfigFile() != null) {
            this.languages = "Typescript";
        }
        startupRequest.setLanguages(this.languages);
    }

    protected SystemOpenRequest createOpenRequest(MavenProject project, File systemDirectory, boolean overrideSonargraphWorkspace) {
        SystemOpenRequest request = new SystemOpenRequest();
        if (systemDirectory != null) {
            request.setSystemDirectory(systemDirectory.getAbsolutePath());
        } else {
            File dir = new File(project.getBasedir(), project.getArtifactId() + ".sonargraph");
            request.setSystemDirectory(dir.getAbsolutePath());
        }
        request.setVirtualModel(this.virtualModel);
        request.setWorkspaceProfile(this.workspaceProfile);
        if (this.qualityModelFile != null) {
            if (this.qualityModelFile.getName().startsWith("Sonargraph:")) {
                request.setQualityModelFile(this.qualityModelFile.getName());
            } else {
                request.setQualityModelFile(this.qualityModelFile.getAbsolutePath());
            }
        }
        if (this.snapshotDirectory != null) {
            request.setSnaphotDirectory(this.snapshotDirectory.getAbsolutePath());
        }
        request.setSnapshotFileName(this.snapshotFileName);
        if (overrideSonargraphWorkspace && this.workspaceProfile == null) {
            request.setSystemInfo(this.getSystemModel(project, null, null, false));
        }
        return request;
    }

    protected String getSystemNameParameter(MavenProject project) {
        return project.getArtifactId();
    }

    protected ReportRequest createReportRequest(MavenProject project) {
        ReportRequest request = new ReportRequest();
        request.setReportDirectory(this.reportDirectory != null ? this.reportDirectory.getAbsolutePath() : null);
        request.setReportFileName(this.reportFileName);
        request.setReportType(this.reportType);
        request.setReportFormat(this.reportFormat);
        request.setSplitByModule(this.splitByModule);
        request.setElementCountToSplitHtmlReport(this.elementCountToSplitHtmlReport);
        request.setMaxElementCountForHtmlDetailsPage(this.maxElementCountForHtmlDetailsPage);
        request.setPrepareForSonarQube(this.prepareForSonarQube);
        if (this.prepareForSonarQube) {
            request.setReportDistributionDirectories(Collections.singletonList(new File(project.getBuild().getDirectory())));
            request.setAdditionalTargetReportFileName("sonargraph-sonarqube-report.xml");
        }
        request.setBaselineReportPath(this.baselineReportPath);
        request.setTimestampAsString(this.timestamp);
        request.setContextInfo(this.contextInfo);
        request.setUploadHostUrl(this.getUploadHostUrl());
        request.setCreateAndUploadSnapshot(this.isCreateAndUploadSnapshot());
        request.setClientKey(this.getClientKey());
        if (this.getFailedUploadDirectory() != null) {
            request.setFailedUploadDirectory(this.getFailedUploadDirectory().getAbsolutePath());
        }
        request.setBranch(this.branch);
        request.setCommitId(this.commitId);
        request.setVersion(this.version);
        return request;
    }

    public FailSet convertFailSet() {
        if (this.failSet == null) {
            return null;
        }
        FailSet internalFailSet = new FailSet();
        internalFailSet.setFailOnEmptyWorkspace(this.failSet.isFailOnEmptyWorkspace());
        internalFailSet.setFailOnIssues(this.failSet.isFailOnIssues());
        for (Include include : this.failSet.getIncludes()) {
            internalFailSet.addIncludeIssueFilter((IssueFilter)new IssueFilter.Builder().issueType(include.getIssueType()).severity(include.getSeverity()).resolution(include.getResolution()).create());
        }
        for (Exclude exclude : this.failSet.getExcludes()) {
            internalFailSet.addExcludeIssueFilter((IssueFilter)new IssueFilter.Builder().issueType(exclude.getIssueType()).severity(exclude.getSeverity()).resolution(exclude.getResolution()).create());
        }
        return internalFailSet;
    }

    private RootPathInfo createRootPathIfExists(String path, RootPathInfo.Category category) {
        if (path != null && new File(path).isDirectory()) {
            return new RootPathInfo(path, category);
        }
        return null;
    }

    private ModuleInfo processMavenProject(MavenProject project, boolean useGroupIdInModuleName) {
        ArrayList<RootPathInfo> validRootPaths = new ArrayList<RootPathInfo>();
        Iterator iterator = project.getCompileSourceRoots().iterator();
        while (iterator.hasNext()) {
            String src;
            boolean isGeneratedSource = this.isGeneratedSourceDirectory(project, src = (String)iterator.next());
            RootPathInfo root = this.createRootPathIfExists(src, isGeneratedSource ? RootPathInfo.Category.GENERATED_SOURCE : RootPathInfo.Category.SOURCE);
            if (root == null) continue;
            validRootPaths.add(root);
        }
        String outDir = project.getBuild().getOutputDirectory();
        RootPathInfo out = this.createRootPathIfExists(outDir, RootPathInfo.Category.OUT);
        if (out != null) {
            validRootPaths.add(out);
        }
        if (this.includeTestCode) {
            for (String src : project.getTestCompileSourceRoots()) {
                RootPathInfo root = this.createRootPathIfExists(src, RootPathInfo.Category.SOURCE);
                if (root == null) continue;
                validRootPaths.add(root);
            }
            String testOutDir = project.getBuild().getTestOutputDirectory();
            RootPathInfo testOut = this.createRootPathIfExists(testOutDir, RootPathInfo.Category.OUT);
            if (testOut != null) {
                validRootPaths.add(testOut);
            }
        }
        if (!validRootPaths.isEmpty() || this.includeEmptyModules) {
            String id = project.getGroupId() + "_" + project.getArtifactId();
            Object name = useGroupIdInModuleName ? id : project.getArtifactId();
            ModuleInfo module = new ModuleInfo(id, (String)name, project.getDescription(), "Java");
            for (RootPathInfo root : validRootPaths) {
                module.addRootPath(root);
            }
            return module;
        }
        return null;
    }

    private boolean isGeneratedSourceDirectory(MavenProject project, String src) {
        assert (project != null) : "Parameter 'project' of method 'isGeneratedSourceDirectory' must not be null";
        assert (src != null && src.length() > 0) : "Parameter 'src' of method 'isGeneratedSourceDirectory' must not be empty";
        String outputDirectory = project.getBuild().getOutputDirectory();
        return src.startsWith(outputDirectory);
    }

    protected File getTsConfigFile() {
        return null;
    }

    protected File getPythonRoot() {
        return null;
    }

    protected File getPythonVirtualEnvironment() {
        return null;
    }

    protected SystemInfo getSystemModel(MavenProject project, String systemId, File systemBaseDirectory, boolean useGroupIdInModuleName) {
        if (systemId == null) {
            systemId = project.getGroupId() + "_" + project.getArtifactId();
        }
        File baseDirectory = systemBaseDirectory != null ? systemBaseDirectory : project.getBasedir();
        SystemInfo system = new SystemInfo((String)systemId, this.getSystemNameParameter(project), project.getDescription(), baseDirectory.getAbsolutePath());
        File tsConfigFile = this.getTsConfigFile();
        File pythonRoot = this.getPythonRoot();
        if (tsConfigFile != null) {
            system.setTsConfigFile(tsConfigFile);
            ModuleInfo module = new ModuleInfo(system.getName(), system.getName(), "", "Typescript");
            system.addModule(module);
            RootPathInfo root = new RootPathInfo(tsConfigFile.getParentFile().getAbsolutePath(), RootPathInfo.Category.SOURCE);
            module.addRootPath(root);
            this.languages = "Typescript";
        } else if (pythonRoot != null) {
            system.setPythonRoot(pythonRoot);
            ModuleInfo module = new ModuleInfo(system.getName(), system.getName(), "", "Python");
            system.addModule(module);
            RootPathInfo root = new RootPathInfo(pythonRoot.getAbsolutePath(), RootPathInfo.Category.SOURCE);
            module.addRootPath(root);
            this.languages = "Python";
        } else {
            ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
            HashMap<CallSite, ModuleInfo> artifactMap = new HashMap<CallSite, ModuleInfo>();
            HashMap<MavenProject, ModuleInfo> moduleMap = new HashMap<MavenProject, ModuleInfo>();
            int moduleCount = 0;
            projects.add(project);
            for (MavenProject p : project.getCollectedProjects()) {
                if (MavenPackaging.isIgnoredMavenPackaging(p.getPackaging())) continue;
                projects.add(p);
            }
            for (MavenProject next : projects) {
                ModuleInfo module = this.processMavenProject(next, useGroupIdInModuleName);
                if (module == null) continue;
                artifactMap.put((CallSite)((Object)(next.getGroupId() + ":" + next.getArtifactId())), module);
                moduleMap.put(next, module);
                system.addModule(module);
                ++moduleCount;
            }
            if (moduleCount > 1) {
                for (MavenProject next : projects) {
                    ModuleInfo from = (ModuleInfo)moduleMap.get(next);
                    if (from == null) continue;
                    for (Dependency dep : next.getDependencies()) {
                        String key;
                        ModuleInfo target;
                        if (!dep.getScope().equals("compile") || (target = (ModuleInfo)artifactMap.get(key = dep.getGroupId() + ":" + dep.getArtifactId())) == null) continue;
                        from.addModuleDependency(target);
                    }
                }
            }
        }
        return system.hasModules() ? system : null;
    }

    protected File getQualityModelFile() {
        return this.qualityModelFile;
    }
}

