/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client.maven;

import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import com.hello2morrow.sonargraph.build.api.ServiceResponse;
import com.hello2morrow.sonargraph.build.api.StartupRequest;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildClient;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildInteraction;
import com.hello2morrow.sonargraph.build.client.IUpdatableClient;
import com.hello2morrow.sonargraph.build.client.SonargraphBuildClientVersionManager;
import com.hello2morrow.sonargraph.build.client.SonargraphBuildInstallationManager;
import com.hello2morrow.sonargraph.build.client.SonargraphBuildTransaction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

abstract class AbstractSonargraphMojo
extends AbstractMojo
implements ISonargraphBuildClient,
IUpdatableClient {
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(property="sonargraph.repository")
    private String repository;
    @Parameter(property="sonargraph.useHttpProxyHost")
    private String useHttpProxyHost;
    @Parameter(property="sonargraph.installationDirectory")
    private File installationDirectory;
    @Parameter(defaultValue="same", property="sonargraph.sonargraphBuildVersion", required=false)
    private String sonargraphBuildVersion;
    @Parameter(defaultValue="false", property="sonargraph.autoUpdate", required=false)
    private boolean autoUpdate;
    @Parameter(property="sonargraph.activationCode")
    private String activationCode;
    @Parameter(property="sonargraph.waitForLicense")
    private String waitForLicense;
    @Parameter(property="sonargraph.licenseServerHost")
    private String licenseServerHost;
    @Parameter(property="sonargraph.licenseServerUrl")
    private String licenseServerUrl;
    @Parameter(property="sonargraph.licenseServerPort", defaultValue="8080")
    private String licenseServerPort;
    @Parameter(property="sonargraph.licenseFile")
    private String licenseFile;
    @Parameter(property="sonargraph.logFile")
    private File logFile;
    @Parameter(property="sonargraph.logLevel", defaultValue="info")
    private String logLevel;
    @Parameter(property="sonargraph.analyzerExceutionLevel", defaultValue="FULL")
    private String analyzerExecutionLevel;
    @Parameter(property="sonargraph.progressInfo", defaultValue="none")
    private String progressInfo;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false", property="sonargraph.skip")
    private boolean skip;
    @Parameter(defaultValue="", property="sonargraph.uploadHostUrl")
    private String uploadHostUrl;
    @Parameter(defaultValue="true", property="sonargraph.createAndUploadSnapshot")
    private boolean createAndUploadSnapshot;
    @Parameter(property="sonargraph.failedUploadDirectory")
    private File failedUploadDirectory;
    @Parameter(property="sonargraph.clientKey")
    private String clientKey;
    private final SonargraphBuildClientVersionManager m_versionManager = new SonargraphBuildClientVersionManager();
    private String m_proxyHost;
    private String m_proxyPort;
    private String m_proxyUsername;
    private String m_proxyPassword;

    protected AbstractSonargraphMojo() {
    }

    private String getAbsolutePath(File file) {
        if (file == null) {
            return "";
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    protected void logStartupInfo() {
        String version = "";
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("version.properties");){
            Properties props = new Properties();
            props.load(input);
            version = props.getProperty("sonargraph.version");
        }
        catch (IOException | NullPointerException e) {
            version = "unable to read version.properties";
        }
        this.info("Startup info [" + this.getClass().getName() + ":" + version + "]");
        this.info("'sonargraph.installationDirectory'='" + this.getAbsolutePath(this.installationDirectory) + "'");
    }

    @Override
    public final String getClientName() {
        return "Maven";
    }

    @Override
    public final File getDefaultOutputDirectory() {
        return new File(this.project.getBuild().getDirectory());
    }

    @Override
    public File getProjectDirectory() {
        return this.project.getBasedir();
    }

    @Override
    public void configureClassPath(File osgiJarFile) throws Exception {
        assert (osgiJarFile != null && osgiJarFile.canRead());
        ClassRealm classLoader = (ClassRealm)Thread.currentThread().getContextClassLoader();
        URL osgiJarURL = osgiJarFile.toURI().toURL();
        classLoader.addURL(osgiJarURL);
    }

    @Override
    public void info(String msg) {
        this.getLog().info((CharSequence)msg);
    }

    @Override
    public void error(String msg) {
        this.getLog().error((CharSequence)msg);
    }

    @Override
    public ISonargraphBuild.Version getVersion() {
        return this.m_versionManager.getVersion();
    }

    protected final String getClientKey() {
        return this.clientKey;
    }

    protected final File getFailedUploadDirectory() {
        return this.failedUploadDirectory;
    }

    protected final String getUploadHostUrl() {
        return this.uploadHostUrl;
    }

    protected final boolean isCreateAndUploadSnapshot() {
        return this.createAndUploadSnapshot;
    }

    private boolean checkTychoPlugin() {
        ClassRealm classLoader = (ClassRealm)Thread.currentThread().getContextClassLoader();
        for (ClassRealm realm : classLoader.getWorld().getRealms()) {
            if (!realm.getId().startsWith("extension>org.eclipse.tycho")) continue;
            return true;
        }
        return false;
    }

    private void determineHttpProxyParameters() throws MojoExecutionException {
        if (this.useHttpProxyHost != null) {
            List proxies = this.settings.getProxies();
            for (Object next : proxies) {
                if (!(next instanceof Proxy)) {
                    this.getLog().error((CharSequence)("Not a proxy object: " + next.getClass().getName()));
                    continue;
                }
                Proxy proxy = (Proxy)next;
                if (!proxy.getProtocol().toLowerCase().equals("http") || !proxy.getHost().equals(this.useHttpProxyHost) && !proxy.getId().equals(this.useHttpProxyHost)) continue;
                this.m_proxyHost = proxy.getHost();
                this.m_proxyPort = Integer.toString(proxy.getPort());
                this.m_proxyUsername = proxy.getUsername();
                this.m_proxyPassword = proxy.getPassword();
                break;
            }
            if (this.m_proxyHost == null) {
                String msg = String.format("Cannot locate proxy '%s' in Maven settings", this.useHttpProxyHost);
                this.getLog().info((CharSequence)msg);
                throw new MojoExecutionException(msg);
            }
        }
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.info("Skipping Sonargraph");
            return;
        }
        if (this.checkTychoPlugin()) {
            String message = "Tycho plugin detected. Sonargraph plugin will not work together with Tycho plugin. You need to execute Sonargraph differently, using the Command-line, Ant or Gradle integrations.";
            String help = "For more information, please read Sonargraph Build Manual at https://eclipse.hello2morrow.com/doc/build/content/integrating_with_maven.html";
            this.error("Tycho plugin detected. Sonargraph plugin will not work together with Tycho plugin. You need to execute Sonargraph differently, using the Command-line, Ant or Gradle integrations.");
            this.error("For more information, please read Sonargraph Build Manual at https://eclipse.hello2morrow.com/doc/build/content/integrating_with_maven.html");
            throw new MojoExecutionException("Tycho plugin detected. Sonargraph plugin will not work together with Tycho plugin. You need to execute Sonargraph differently, using the Command-line, Ant or Gradle integrations.\nFor more information, please read Sonargraph Build Manual at https://eclipse.hello2morrow.com/doc/build/content/integrating_with_maven.html");
        }
        this.determineHttpProxyParameters();
        if (this.autoUpdate || this.installationDirectory == null) {
            this.info("Checking SonargraphBuild Installation");
            SonargraphBuildInstallationManager mgr = new SonargraphBuildInstallationManager(this, this.m_proxyHost, this.m_proxyPort, this.m_proxyUsername, this.m_proxyPassword, this.repository);
            this.installationDirectory = mgr.getSonargraphBuildInstallation(this.autoUpdate, this.sonargraphBuildVersion, this.getVersion().getVersionWithoutBuildNumber());
            if (this.installationDirectory == null) {
                throw new MojoExecutionException(mgr.getErrorMessage());
            }
            String updateInfo = mgr.getUpdateInfo();
            if (updateInfo != null) {
                this.info(updateInfo);
            }
        }
        if (this.installationDirectory == null) {
            throw new MojoExecutionException("Parameter 'installationDirectory' is missing");
        }
        String actualInstallationDirectory = Paths.get(this.installationDirectory.getAbsolutePath(), new String[0]).normalize().toString();
        this.info("Using SonargraphBuild: " + actualInstallationDirectory);
        try {
            File osgiJar = SonargraphBuildInstallationManager.determineOsgiJar(new File(actualInstallationDirectory));
            this.configureClassPath(osgiJar);
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
        ServiceResponse transactionResponse = null;
        long startTime = System.currentTimeMillis();
        try {
            StartupRequest startupRequest = this.createStartupRequest(actualInstallationDirectory);
            this.modifyStartupRequest(startupRequest);
            this.logStartupInfo();
            SonargraphBuildTransaction transaction = new SonargraphBuildTransaction(this, startupRequest, this.createInteractions(this.project, startupRequest));
            transactionResponse = transaction.execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (transactionResponse == null) {
            throw new MojoExecutionException("Failed to execute SonargraphBuild!");
        }
        if (transactionResponse.isFailure()) {
            throw new MojoExecutionException("Failed to execute SonargraphBuild: \n" + transactionResponse.getStatusMessage());
        }
        this.info("SonargraphBuild: Completed successfully after " + (System.currentTimeMillis() - startTime) + " ms.");
    }

    protected void modifyStartupRequest(StartupRequest startupRequest) {
    }

    protected StartupRequest createStartupRequest(String actualInstallationDirectory) {
        StartupRequest request = new StartupRequest();
        request.setInstallationDirectory(actualInstallationDirectory);
        request.setActivationCode(this.activationCode);
        request.setWaitForLicenseString(this.waitForLicense);
        request.setLicenseFile(this.licenseFile);
        request.setLicenseServerHost(this.licenseServerHost);
        request.setLicenseServerPort(this.licenseServerPort);
        request.setLicenseServerUrl(this.licenseServerUrl);
        request.setAnalyzerExecutionLevel(this.analyzerExecutionLevel);
        request.setLogFile(this.logFile != null ? this.logFile.getAbsolutePath() : null);
        request.setLogLevel(this.logLevel);
        request.setProgressInfoAsString(this.progressInfo);
        request.setProxyHost(this.m_proxyHost);
        request.setProxyPort(this.m_proxyPort);
        request.setProxyUsername(this.m_proxyUsername);
        request.setProxyPassword(this.m_proxyPassword);
        return request;
    }

    protected abstract List<ISonargraphBuildInteraction> createInteractions(MavenProject var1, StartupRequest var2) throws MojoExecutionException;
}

