/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class StandardDownloader {
    private static final String PROXY_INFO_MSG = "\n\nThe reason might be a missing or wrong proxy configuration.\nCheck the user manual at https://eclipse.hello2morrow.com/doc/build/content/index.html";
    private static final String TOC_URL = "https://eclipse.hello2morrow.com/jenkins/sonargraphBuild/sonargraphBuild.json";
    private final Proxy m_proxy;
    private final String m_repository;
    private String m_requestedUrl;

    public StandardDownloader(String proxyHost, String proxyPort, final String proxyUser, final String proxyPassword, String repository) {
        if (proxyHost != null && proxyHost.length() > 0) {
            assert (proxyPort != null) : "'proxyPort' must not be null";
            this.m_proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)Integer.valueOf(proxyPort)));
            if (proxyUser != null) {
                assert (proxyPassword != null) : "'proxyPassword' must not be null";
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                });
            }
        } else {
            this.m_proxy = Proxy.NO_PROXY;
        }
        this.m_repository = repository != null && !repository.isEmpty() ? repository : TOC_URL;
    }

    public String getRequestedUrl() {
        return this.m_requestedUrl;
    }

    public void setRequestedUrl(String m_requestedUrl) {
        this.m_requestedUrl = m_requestedUrl;
    }

    protected JSONObject getVersionData(URL url) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openConnection(this.m_proxy).getInputStream()));){
            JSONObject jSONObject = (JSONObject)JSONValue.parseWithException((Reader)reader);
            return jSONObject;
        }
    }

    public final String determineMatchingUrl(String versionToMatch, VersionFlag versionFlag) throws Exception {
        assert (versionFlag != null) : "Parameter 'versionFlag' of method 'determineMatchingUrl' must not be null";
        Object result = null;
        try {
            JSONArray versions = (JSONArray)this.getVersionData(new URI(this.m_repository).toURL()).get((Object)"list");
            String youngestDatePart = null;
            for (Object obj : versions) {
                JSONObject entry = (JSONObject)obj;
                String entryVersion = (String)entry.get((Object)"id");
                String url = (String)entry.get((Object)"url");
                if (versionFlag == VersionFlag.NEWEST && entryVersion.equals("newest")) {
                    result = url;
                    break;
                }
                if (versionFlag == VersionFlag.SAME && entryVersion.equals(versionToMatch)) {
                    result = url;
                    break;
                }
                if (versionFlag != VersionFlag.NEWEST_MATCHING || entryVersion.equals("newest") || !(entryVersion + ".").startsWith(versionToMatch + ".")) continue;
                String datePart = url.substring(url.lastIndexOf(95) + 1);
                if (youngestDatePart != null && datePart.compareTo(youngestDatePart) <= 0) continue;
                result = url;
                youngestDatePart = datePart;
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new IOException(String.format("%s%s", e.getClass().getName(), msg == null ? "" : ": " + msg) + PROXY_INFO_MSG);
        }
        if (result == null) {
            throw new IOException("No SonargraphBuild version matches '" + versionToMatch + "'.");
        }
        if (((String)result).startsWith("http:")) {
            result = "https:" + ((String)result).substring(5);
        }
        this.m_requestedUrl = result;
        return result;
    }

    public static String getVersionFromUrl(String url) {
        assert (url != null) : "Parameter 'url' of method 'getVersionFromUrl' must not be null";
        String postFix = "_yyyy-mm-dd.zip";
        assert (url.length() > "_yyyy-mm-dd.zip".length()) : "Wrong url format: " + url;
        int lastSlash = url.lastIndexOf(47);
        assert (lastSlash > 0) : "Wrong url format: " + url;
        return url.substring(lastSlash + 1, url.length() - "_yyyy-mm-dd.zip".length());
    }

    public void downloadIntoDirectory(IProgressReporter reporter, File sonargraphBuildRoot, String downloadUrl) throws IOException {
        assert (reporter != null) : "Parameter 'reporter' of method 'downloadIntoDirectory' must not be null";
        assert (sonargraphBuildRoot != null) : "Parameter 'sonargraphBuildRoot' of method 'downloadIntoDirectory' must not be null";
        assert (downloadUrl != null && downloadUrl.length() > 0) : "Parameter 'downloadUrl' of method 'downloadIntoDirectory' must not be empty";
        if (!sonargraphBuildRoot.exists()) {
            sonargraphBuildRoot.mkdirs();
        }
        try (ZipInputStream zip = new ZipInputStream(new URI(downloadUrl).toURL().openConnection(this.m_proxy).getInputStream());){
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (!name.contains("/example/") && !name.contains("/doc/")) {
                    reporter.notify(name);
                    File file = new File(sonargraphBuildRoot.getPath() + File.separatorChar + entry.getName());
                    if (entry.isDirectory()) {
                        file.mkdir();
                    } else {
                        this.extract(zip, file);
                    }
                }
                entry = zip.getNextEntry();
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new IOException(String.format("Failed to download SonargraphBuild from %s: %s%s", downloadUrl, e.getClass().getName(), msg == null ? "" : ": " + msg) + "\n\nThe reason might be a missing or wrong proxy configuration.\nCheck the user manual at https://eclipse.hello2morrow.com/doc/build/content/index.html\nIf the build server cannot connect to the internet, download and extract SonargraphBuild to the build server and use the parameter 'installationDirectory'.");
        }
    }

    private void extract(ZipInputStream input, File out) throws IOException {
        byte[] buffer = new byte[0x100000];
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(out));){
            int read;
            while ((read = input.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, read);
            }
        }
    }

    public static String getDirectoryNameFromUrl(String url) {
        assert (url != null && url.length() > 0) : "Parameter 'url' of method 'getDirectoryNameFromUrl' must not be empty";
        assert (url.length() > 8) : "Parameter 'url' does not have the correct format: " + url;
        int startIndex = url.lastIndexOf(47);
        int endIndex = url.length() - ".zip".length();
        assert (startIndex > 0) : "Parameter 'url' does not have the correct format: " + url;
        assert (endIndex > 0 && endIndex > startIndex) : "Parameter 'url' does not have the correct format: " + url;
        String directorName = url.substring(startIndex + 1, endIndex);
        return directorName;
    }

    public static enum VersionFlag {
        SAME,
        NEWEST,
        NEWEST_MATCHING;


        public String getPresentationName() {
            return this.name().toLowerCase();
        }
    }

    public static interface IProgressReporter {
        public void notify(String var1);
    }
}

