/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client.maven;

import com.hello2morrow.sonargraph.build.api.ReportRequest;
import com.hello2morrow.sonargraph.build.api.StartupRequest;
import com.hello2morrow.sonargraph.build.api.SystemOpenRequest;
import com.hello2morrow.sonargraph.build.client.CreateReportInteraction;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildInteraction;
import com.hello2morrow.sonargraph.build.client.Params;
import com.hello2morrow.sonargraph.build.client.maven.AbstractSonargraphReportMojo;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="create-report", aggregator=true)
public class SonargraphReportMojo
extends AbstractSonargraphReportMojo {
    @Parameter(property="sonargraph.compilerDefinitionPath", required=false)
    private String compilerDefinitionPath;
    @Parameter(property="sonargraph.pythonInterpreterPath", required=false)
    private String pythonInterpreterPath;
    @Parameter(property="sonargraph.requiredInstallationProfiles", required=false)
    private String requiredInstallationProfiles;
    @Parameter(property="sonargraph.systemDirectory", required=false)
    private File systemDirectory;
    @Parameter(defaultValue="true", property="sonargraph.overrideSonargraphWorkspace", required=false)
    private boolean overrideSonargraphWorkspace;
    @Parameter(property="sonargraph.numberOfDaemons")
    private final int numberOfDaemons = 0;
    @Parameter(property="sonargraph.daemonStackSize")
    private final int daemonStackSize = 0;

    @Override
    protected void logStartupInfo() {
        super.logStartupInfo();
        this.info("'overrideSonargraphWorkspace'='" + this.overrideSonargraphWorkspace + "'");
    }

    @Override
    protected StartupRequest createStartupRequest(String actualInstallationDirectory) {
        StartupRequest request = super.createStartupRequest(actualInstallationDirectory);
        if (this.compilerDefinitionPath != null && !this.compilerDefinitionPath.trim().isEmpty()) {
            request.addLanguageIfNotPresent("CPlusPlus");
        }
        return request;
    }

    @Override
    protected SystemOpenRequest createOpenRequest(MavenProject project, File systemDirectory, boolean overrideSonargraphWorkspace) {
        SystemOpenRequest request = super.createOpenRequest(project, systemDirectory, overrideSonargraphWorkspace);
        request.setInstallationSpecificParameter(Params.COMPILER_DEFINITION_PATH.getParameterName(), this.compilerDefinitionPath);
        request.setInstallationSpecificParameter(Params.PYTHON_INTERPRETER_PATH.getParameterName(), this.pythonInterpreterPath);
        request.setInstallationSpecificParameter(Params.REQUIRED_INSTALLATION_PROFILES.getParameterName(), this.requiredInstallationProfiles);
        request.setInstallationSpecificParameter(Params.DAEMON_STACK_SIZE.getParameterName(), String.valueOf(0));
        request.setInstallationSpecificParameter(Params.NUMBER_OF_DAEMONS.getParameterName(), String.valueOf(0));
        return request;
    }

    @Override
    public List<ISonargraphBuildInteraction> createInteractions(MavenProject project, StartupRequest startupRequest) throws MojoExecutionException {
        SystemOpenRequest openRequest = this.createOpenRequest(project, this.systemDirectory, this.overrideSonargraphWorkspace);
        if (openRequest.getInstallationSpecificParameters().containsKey(Params.COMPILER_DEFINITION_PATH.getParameterName())) {
            startupRequest.addLanguageIfNotPresent("CPlusPlus");
        }
        if (openRequest.getInstallationSpecificParameters().containsKey(Params.NUMBER_OF_DAEMONS.getParameterName())) {
            startupRequest.addLanguageIfNotPresent("CPlusPlus");
        }
        if (openRequest.getInstallationSpecificParameters().containsKey(Params.REQUIRED_INSTALLATION_PROFILES.getParameterName())) {
            startupRequest.addLanguageIfNotPresent("CSharp");
        }
        ReportRequest reportRequest = this.createReportRequest(project);
        reportRequest.setUseSonargraphId(true);
        CreateReportInteraction createReport = new CreateReportInteraction(this, openRequest, reportRequest, this.convertFailSet());
        return Arrays.asList(createReport);
    }
}

