/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client.maven;

import com.hello2morrow.sonargraph.build.api.DynamicSystemRequest;
import com.hello2morrow.sonargraph.build.api.StartupRequest;
import com.hello2morrow.sonargraph.build.api.SystemInfo;
import com.hello2morrow.sonargraph.build.client.GenerateSystemInteraction;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildInteraction;
import com.hello2morrow.sonargraph.build.client.maven.AbstractSonargraphReportMojo;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="create-or-update-system", aggregator=true)
public final class SonargraphCreateOrUpdateSystemMojo
extends AbstractSonargraphReportMojo {
    @Parameter(property="sonargraph.systemBaseDirectory", required=false)
    private File systemBaseDirectory;
    @Parameter(property="sonargraph.systemName", required=false)
    private String systemName;
    @Parameter(property="sonargraph.systemId", required=false)
    private String systemId;
    @Parameter(defaultValue="false", property="sonargraph.useGroupIdInModuleName", required=false)
    private boolean useGroupIdInModuleName;

    @Override
    public List<ISonargraphBuildInteraction> createInteractions(MavenProject project, StartupRequest startupRequest) throws MojoExecutionException {
        DynamicSystemRequest systemRequest = this.createSystemRequest(project);
        GenerateSystemInteraction generateSystem = new GenerateSystemInteraction(this, systemRequest);
        List<ISonargraphBuildInteraction> interactions = Arrays.asList(generateSystem);
        return interactions;
    }

    @Override
    protected String getSystemNameParameter(MavenProject project) {
        return this.systemName == null ? super.getSystemNameParameter(project) : this.systemName;
    }

    private DynamicSystemRequest createSystemRequest(MavenProject project) {
        File baseDirectory = this.systemBaseDirectory != null ? this.systemBaseDirectory : this.getProjectDirectory();
        SystemInfo systemInfo = this.getSystemModel(project, this.systemId, baseDirectory, this.useGroupIdInModuleName);
        DynamicSystemRequest request = new DynamicSystemRequest(systemInfo);
        File qualityModelFile = this.getQualityModelFile();
        if (qualityModelFile != null) {
            if (qualityModelFile.getName().startsWith("Sonargraph:")) {
                request.setQualityModelFile(qualityModelFile.getName());
            } else {
                request.setQualityModelFile(qualityModelFile.getAbsolutePath());
            }
        }
        return request;
    }
}

